#include <struct.h>
#include <3dengine.h>

#include "dof.h"
#include "vertlist.h"

DWORD CALLBACK MultipleExport(CFile &OutFile, tObject* pobj, CDirect3D* d3d);

long GetMaterial(tFace* pFace, CDirect3D* pD3D)
{
  return ((pD3D->Materials.Materials[pFace->Material].MatParams.PrimTexture == -1) || 
       (pFace->nRenderFlags & NoBlend)) ?
       pFace->Material*2 : pFace->Material*2+1;
}


DWORD CALLBACK Export(
    CString           tofile,
    CWnd*             pwnd,
    tObjectSet*       Objects,
    tUnDataSet*       UnData,
    CDirect3D*        pD3D,
    SYSTEMREQUESTPROC RequestProc,
    HINSTANCE         AppHIns,
    HINSTANCE         DllHIns)
{
  CFile OutFile;
  if (!OutFile.Open(tofile, CFile::modeCreate | CFile::modeWrite))
    return ShowFailMessage(pwnd, "can not open the specified file.", "invalid file attributes or share violation.", MB_ICONHAND);

  //Now I'll show a dialogBox, where an object for exporting
  //will be selected by user.
  if (!RequestProc)
    return ShowFailMessage(pwnd,
      "Invalid parameters passed to plugin.",
      "Versions mismatch.", MB_ICONHAND);
  
  if ((WORD)(SYSTEMREQUESTPROC)RequestProc(
          Z3D_REQUEST_SELECT_BYNAME,
          Objects,
          "Select objects for exporting.",
          NULL,
          NULL)==IDCANCEL)
    return 0;

  for (ObjCount = 0; ObjCount < Objects->ObjAmount; ObjCount++)
    if (Objects->Selected(ObjCount) && !Objects->Hidden(ObjCount))
      return MultipleExport(OutFile, &Objects->ObjSet[ObjCount], pD3D);

  return 0;

}



//-----------------------------------------------------------
// export
//-----------------------------------------------------------
DWORD CALLBACK MultipleExport(CFile &OutFile, tObject* pobj, CDirect3D* pD3D)
{

  long    MatsUsed = 0;
  long*   MatsMap = NULL;
  long    ObjMatsUsed = 0;
  long*   ObjMatsMap = NULL;
  long    written = 0;
  long    GeomWritten = 0;
  long    NumObjects = 0;
  long    i, j;
  DWORD   ID;

  MatsMap = new long[pD3D->Materials.MaterialsAmount*2];
  DOFBurst Burst;


//------------ Materials ---------------
// Read used materials and export them:
  for (i = 0; i < pD3D->Materials.MaterialsAmount*2; i++)
    MatsMap[i] = -1;//usued;
  for (FaceCount = 0; FaceCount < pobj->FaceTable->FaceAmount; FaceCount++)
  {
    //check material.
    if (-1 == MatsMap[GetMaterial(&(pobj->FaceTable->Table[FaceCount]), pD3D)])
      MatsMap[GetMaterial(&(pobj->FaceTable->Table[FaceCount]), pD3D)] = MatsUsed++;
  }

  //write materials:
  ID = *(DWORD*)"DOF1";
  OutFile.Write(&ID, 4);OutFile.Write(&ID, 4);//size

  ID = *(DWORD*)"MATS";
  OutFile.Write(&ID, 4);OutFile.Write(&ID, 4);//size
  OutFile.Write(&MatsUsed, 4);
  written += 12;
  for (j = 0; j < MatsUsed; j++)
  for (i = 0; i < pD3D->Materials.MaterialsAmount*2; i++)
    if (MatsMap[i] == j)
    {//write material
      long thismatwritten = 0;
      long len;
      ID = *(DWORD*)"MAT0";
      OutFile.Write(&ID, 4);OutFile.Write(&ID, 4);
      written+=8;
    // Header
      ID = *(DWORD*)"MHDR";
      OutFile.Write(&ID, 4);
      short namelen = strlen(pD3D->Materials.Materials[i/2].MaterialName);
      int ClassPos = CString(pD3D->Materials.Materials[i/2].MaterialName).Find("::");
      if (ClassPos >=0)
      {
        len = 4+namelen-2;
        OutFile.Write(&len, 4);
        namelen =  ClassPos;
        OutFile.Write(&namelen,2);
        OutFile.Write(pD3D->Materials.Materials[i/2].MaterialName, namelen);
        namelen = strlen(pD3D->Materials.Materials[i/2].MaterialName) - ClassPos - 2;
        OutFile.Write(&namelen,2);
        if (namelen > 0)
          OutFile.Write(&pD3D->Materials.Materials[i/2].MaterialName[ClassPos+2], namelen);
      }
      else
      {
        len = 4+namelen;
        OutFile.Write(&len, 4);
        OutFile.Write(&namelen,2);
        OutFile.Write(pD3D->Materials.Materials[i/2].MaterialName, namelen);
        namelen = 0;
        OutFile.Write(&namelen,2);
      }
      thismatwritten += len+8;
      len = 0;
    // Colors
      ID = *(DWORD*)"MCOL";
      OutFile.Write(&ID, 4);
      len = sizeof(DOFMat);
      DOFMat mat;
      mat.diffuse[0] = pD3D->Materials.Materials[i/2].MatRec.ambient.r;
      mat.diffuse[1] = pD3D->Materials.Materials[i/2].MatRec.ambient.g;
      mat.diffuse[2] = pD3D->Materials.Materials[i/2].MatRec.ambient.b;
      mat.diffuse[3] = pD3D->Materials.Materials[i/2].MatRec.ambient.a;
      mat.ambient[0] = mat.diffuse[0]*0.075f;
      mat.ambient[1] = mat.diffuse[1]*0.075f;
      mat.ambient[2] = mat.diffuse[2]*0.075f;
      mat.ambient[3] = mat.diffuse[3];
      mat.specular[0] = 1.0f;//mat.diffuse[0]*0.75f;
      mat.specular[1] = 1.0f;//mat.diffuse[1]*0.75f;
      mat.specular[2] = 1.0f;//mat.diffuse[2]*0.75f;
      mat.specular[3] = 1.0f;//mat.diffuse[3];
      mat.emission[0] = mat.diffuse[0]*fdivide(1.0f,pD3D->Materials.Materials[i/2].MatRec.power);
      mat.emission[1] = mat.diffuse[1]*fdivide(1.0f,pD3D->Materials.Materials[i/2].MatRec.power);
      mat.emission[2] = mat.diffuse[2]*fdivide(1.0f,pD3D->Materials.Materials[i/2].MatRec.power);
      mat.emission[3] = mat.diffuse[3];

      mat.shininess = max(0.0f, 128.0f*(1.0f-pD3D->Materials.Materials[i/2].MatParams.Shine));

      OutFile.Write(&len, 4);
      OutFile.Write(&mat, sizeof(DOFMat));
      thismatwritten += len+8;//id, size
      len = 0;
    // UV settings
      ID = *(DWORD*)"MUVW";
      OutFile.Write(&ID, 4);
      len = sizeof(DOFMatUV);
      DOFMatUV matUV;
      matUV.uvwUoffset = 0.0f;
      matUV.uvwVoffset = 0.0f;
      matUV.uvwUtiling = 1.0f;
      matUV.uvwVtiling = 1.0f;
      matUV.uvwAngle   = 0.0f;
      matUV.uvwBlur   = 0.0f;
      matUV.uvwBlurOffset= 0.0f;
      OutFile.Write(&len, 4);
      OutFile.Write(&matUV, sizeof(DOFMatUV));
      thismatwritten += len+8;//id, size
      len = 0;
    // Transparency settings
      ID = *(DWORD*)"MTRA";
      OutFile.Write(&ID, 4);
      len = 8;
      OutFile.Write(&len, 4);
      len = 0;OutFile.Write(&len, 4);
      len = pD3D->Materials.Materials[i/2].MatParams.AlphaTreat;
      OutFile.Write(&len, 4);
      thismatwritten += 16;//id, size, 2xDWORD
      len = 0;
    // Environment mapping
      ID = *(DWORD*)"MCFL";
      OutFile.Write(&ID, 4);
      len = 4;
      OutFile.Write(&len, 4);
      len = (0==i%2) ? 0 : 1;
      OutFile.Write(&len, 4);
      thismatwritten += 12;//id, size, DWORD
      len = 0;
    // Primary texture settings
      if (pD3D->Materials.Materials[i/2].MatParams.PrimTexture >=0)
      {
        ID = *(DWORD*)"MTEX";
        OutFile.Write(&ID, 4);
        short namelen = strlen(pD3D->Materials.Textures->GetName(
          pD3D->Materials.Materials[i/2].MatParams.PrimTexture));
        len = namelen+4;//4 is amount
        OutFile.Write(&len, 4);
        len = 1;//single texture
        OutFile.Write(&len, 4);
        OutFile.Write(&namelen,2);
        OutFile.Write(pD3D->Materials.Textures->GetName(
          pD3D->Materials.Materials[i/2].MatParams.PrimTexture),
          namelen);
        thismatwritten += 8+4+2+namelen;//8=id+size, 4=amount, 2=len, text
        len = 0;
      }
      ID = *(DWORD*)"MEND";
      OutFile.Write(&ID, 4);
      thismatwritten+=4;
      OutFile.Seek(-(thismatwritten+4), CFile::current);
      OutFile.Write(&thismatwritten,4);
      OutFile.Seek(thismatwritten, CFile::current);
      written += thismatwritten;
    }  
  written -= 8;
  OutFile.Seek(-(written+4), CFile::current);//seek to "MATS", but not to "DOF1"
  OutFile.Write(&written,4);
  OutFile.Seek(written, CFile::current);
  written += 8;




//------------ Objects ---------------
  ID = *(DWORD*)"GEOB";
  OutFile.Write(&ID, 4);
  OutFile.Write(&ID, 4);//size
  OutFile.Write(&NumObjects, 4);//will be updated later.
  written+=12;

  Burst.NumBursts = 1;
  Burst.burstStart = new long[1]; Burst.burstStart[0] = 0;
  Burst.burstCount = new long[1]; Burst.burstCount[0] = 0;
  Burst.burstMtlID = new long[1]; Burst.burstMtlID[0] = 0;
  Burst.burstVperP = new long[1]; Burst.burstVperP[0] = 3;

  //count amount of used materials;
  ObjMatsUsed = 0;
  ObjMatsMap = new long[MatsUsed];
  for (i = 0; i < MatsUsed; i++)
    ObjMatsMap[i] = -1;//un-used;
  for (FaceCount = 0; FaceCount < pobj->FaceTable->FaceAmount; FaceCount++)
    if (-1 == ObjMatsMap[MatsMap[GetMaterial(&(pobj->FaceTable->Table[FaceCount]), pD3D)]])
      ObjMatsMap[MatsMap[GetMaterial(&(pobj->FaceTable->Table[FaceCount]), pD3D)]] = ObjMatsUsed++;

  DOFFace*  pFaces = new DOFFace[pobj->FaceTable->FaceAmount];
  long materialID;
  VertexList  List;
  tVert    CurrVert;

  for (i = 0; i < ObjMatsUsed; i++)
  {//split by materials.
    long FacesUsed = 0;
    Burst.burstCount[0] = 0;
    NumObjects++;
    for (FaceCount = 0; FaceCount < pobj->FaceTable->FaceAmount; FaceCount++)
      if (ObjMatsMap[MatsMap[GetMaterial(&(pobj->FaceTable->Table[FaceCount]), pD3D)]] == i)
      {//this burst: create vertices set.
        //check material.
        materialID = MatsMap[GetMaterial(&(pobj->FaceTable->Table[FaceCount]), pD3D)];
        CurrVert.vert.x = pobj->VertTable->Table[pobj->FaceTable->Table[FaceCount].I1].X;
        CurrVert.vert.y = pobj->VertTable->Table[pobj->FaceTable->Table[FaceCount].I1].Y;
        CurrVert.vert.z = pobj->VertTable->Table[pobj->FaceTable->Table[FaceCount].I1].Z;
        CurrVert.vert.nx= pobj->VertTable->Table[pobj->FaceTable->Table[FaceCount].I1].NormalX;
        CurrVert.vert.ny= pobj->VertTable->Table[pobj->FaceTable->Table[FaceCount].I1].NormalY;
        CurrVert.vert.nz= pobj->VertTable->Table[pobj->FaceTable->Table[FaceCount].I1].NormalZ;
        CurrVert.vert.u = pobj->FaceTable->Table[FaceCount].U1;
        CurrVert.vert.v = 1.0f-pobj->FaceTable->Table[FaceCount].V1;
        pFaces[FacesUsed].i2 = (signed short)List.Find(CurrVert);
        if (pFaces[FacesUsed].i2 == -1)
        {
          pFaces[FacesUsed].i2 = (signed short)List.Add(CurrVert);
          Burst.burstCount[0]+= 3;
        }
        CurrVert.vert.x = pobj->VertTable->Table[pobj->FaceTable->Table[FaceCount].I2].X;
        CurrVert.vert.y = pobj->VertTable->Table[pobj->FaceTable->Table[FaceCount].I2].Y;
        CurrVert.vert.z = pobj->VertTable->Table[pobj->FaceTable->Table[FaceCount].I2].Z;
        CurrVert.vert.nx= pobj->VertTable->Table[pobj->FaceTable->Table[FaceCount].I2].NormalX;
        CurrVert.vert.ny= pobj->VertTable->Table[pobj->FaceTable->Table[FaceCount].I2].NormalY;
        CurrVert.vert.nz= pobj->VertTable->Table[pobj->FaceTable->Table[FaceCount].I2].NormalZ;
        CurrVert.vert.u = pobj->FaceTable->Table[FaceCount].U2;
        CurrVert.vert.v = 1.0f-pobj->FaceTable->Table[FaceCount].V2;
        pFaces[FacesUsed].i1 = (signed short)List.Find(CurrVert);
        if (pFaces[FacesUsed].i1 == -1)
        {
          pFaces[FacesUsed].i1 = (signed short)List.Add(CurrVert);
          Burst.burstCount[0]+= 3;
        }
        CurrVert.vert.x = pobj->VertTable->Table[pobj->FaceTable->Table[FaceCount].I3].X;
        CurrVert.vert.y = pobj->VertTable->Table[pobj->FaceTable->Table[FaceCount].I3].Y;
        CurrVert.vert.z = pobj->VertTable->Table[pobj->FaceTable->Table[FaceCount].I3].Z;
        CurrVert.vert.nx= pobj->VertTable->Table[pobj->FaceTable->Table[FaceCount].I3].NormalX;
        CurrVert.vert.ny= pobj->VertTable->Table[pobj->FaceTable->Table[FaceCount].I3].NormalY;
        CurrVert.vert.nz= pobj->VertTable->Table[pobj->FaceTable->Table[FaceCount].I3].NormalZ;
        CurrVert.vert.u = pobj->FaceTable->Table[FaceCount].U3;
        CurrVert.vert.v = 1.0f-pobj->FaceTable->Table[FaceCount].V3;
        pFaces[FacesUsed].i3 = (signed short)List.Find(CurrVert);
        if (pFaces[FacesUsed].i3 == -1)
        {
          pFaces[FacesUsed].i3 = (signed short)List.Add(CurrVert);
          Burst.burstCount[0]+= 3;
        }
        FacesUsed++;
      }
//-------------------------------
//  writing object
    ID = *(DWORD*)"GOB1";
    OutFile.Write(&ID, 4);
    long vertamount = Burst.burstCount[0]/3;
    tPOINT* pVerts  = new tPOINT[vertamount];
    tPOINT* pNorms  = new tPOINT[vertamount];
    tPOINT2D* pUVs  = new tPOINT2D[vertamount];
    VertListNode*  Ptr = List.Head;
    j = 0;
    while (Ptr && (j < vertamount))
    {
      pVerts[j].x = Ptr->vert.vert.x;
      pVerts[j].y = Ptr->vert.vert.y;
      pVerts[j].z = Ptr->vert.vert.z;
      pNorms[j].x = Ptr->vert.vert.nx;
      pNorms[j].y = Ptr->vert.vert.ny;
      pNorms[j].z = Ptr->vert.vert.nz;
      pUVs[j].x = Ptr->vert.vert.u;
      pUVs[j].y = Ptr->vert.vert.v;
      j++;
      Ptr = Ptr->next;
    }
    if (j != vertamount)
    {
      char str[64];
      sprintf(str, "Split to materials is done improperly. Expected: %u, found: %u\r\n"
          "Try to assign all faces to one material and export. Then reexport.", vertamount, j);
      AfxMessageBox(str);
    }
    List.Empty();

    long GeomLen =  8+ //GHDR,size
            12+//header's flags, paint, material.
            12+//INDI, size, amount
            sizeof(DOFFace)*FacesUsed+
            12+//VERT, size, amount
            sizeof(tPOINT)*vertamount+
            12+//TVER, size, amount
            sizeof(tPOINT2D)*vertamount+
            12+//NORM, size, amount
            sizeof(tPOINT)*vertamount+
            8+//BRST, size
            sizeof(DOFBurst)+
            4;//GEND
    GeomWritten+=GeomLen;
    OutFile.Write(&GeomLen, 4);//size
    ID = *(DWORD*)"GHDR";
    OutFile.Write(&ID, 4);
    GeomLen = 12;OutFile.Write(&GeomLen, 4);
    GeomLen = 0;
    //flags, paint, material.
    OutFile.Write(&GeomLen, 4);OutFile.Write(&GeomLen, 4);
    OutFile.Write(&materialID, 4);

    ID = *(DWORD*)"INDI";
    OutFile.Write(&ID, 4);
    GeomLen = sizeof(DOFFace)*FacesUsed+4;
    OutFile.Write(&GeomLen, 4);
    GeomLen = FacesUsed*3;
    OutFile.Write(&GeomLen, 4);
    OutFile.Write(pFaces, sizeof(DOFFace)*FacesUsed);

    ID = *(DWORD*)"VERT";
    OutFile.Write(&ID, 4);
    GeomLen = sizeof(tPOINT)*vertamount;
    OutFile.Write(&GeomLen, 4);
    GeomLen = vertamount;
    OutFile.Write(&GeomLen, 4);
    OutFile.Write(pVerts, sizeof(tPOINT)*vertamount);

    ID = *(DWORD*)"TVER";
    OutFile.Write(&ID, 4);
    GeomLen = sizeof(tPOINT2D)*vertamount;
    OutFile.Write(&GeomLen, 4);
    GeomLen = vertamount;
    OutFile.Write(&GeomLen, 4);
    OutFile.Write(pUVs, sizeof(tPOINT2D)*vertamount);

    ID = *(DWORD*)"NORM";
    OutFile.Write(&ID, 4);
    GeomLen = sizeof(tPOINT)*vertamount;
    OutFile.Write(&GeomLen, 4);
    GeomLen = vertamount;
    OutFile.Write(&GeomLen, 4);
    OutFile.Write(pNorms, sizeof(tPOINT)*vertamount);

    ID = *(DWORD*)"BRST";
    OutFile.Write(&ID, 4);
    GeomLen = sizeof(DOFBurst);
  //---------brst fix
    Burst.burstCount[0] = FacesUsed*9;
    OutFile.Write(&GeomLen, 4);
    OutFile.Write(&Burst.NumBursts, 4);
    OutFile.Write(Burst.burstStart, 4);
    OutFile.Write(Burst.burstCount, 4);
    OutFile.Write(Burst.burstMtlID, 4);
    OutFile.Write(Burst.burstVperP, 4);

    ID = *(DWORD*)"GEND";
    OutFile.Write(&ID, 4);
  
    if (pVerts)  delete[] pVerts;
    if (pNorms)  delete[] pNorms;
    if (pUVs)  delete[] pUVs;
    GeomWritten+=8; //"GOB1" id and size
  }//split by materials.

  if (ObjMatsMap)  delete ObjMatsMap;
  if (pFaces)    delete[] pFaces;
  GeomWritten+=8; //to seek to "GEOB", but not to "GOB1"; (id, size, amount)
  OutFile.Seek(-GeomWritten, CFile::current);
  OutFile.Write(&GeomWritten,4); //size
  OutFile.Write(&NumObjects,4);  //amount of objects
  OutFile.Seek(GeomWritten-4, CFile::current);
  
  ID = *(DWORD*)"EDOF";
  OutFile.Write(&ID, 4);

  written+=GeomWritten;
  OutFile.Seek(-(written+4), CFile::current);
  OutFile.Write(&written,4);

  if (MatsMap)
    delete[] MatsMap;
  delete[] Burst.burstStart;
  delete[] Burst.burstCount;
  delete[] Burst.burstMtlID;
  delete[] Burst.burstVperP;

  return Z3D_PLUGRESULT_SELECTIONCHANGED;
}